/*
 * Decompiled with CFR 0.152.
 */
package com.nx.nxprojit.utils;

import com.nx.nxprojit.utils.FileUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlToLuaConverter {
    private static Map<String, List<TipSymbol>> mSymbolsList;
    private static Map<String, TipSymbol> mSymbols;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, TipSymbol> parseSymbolXmls(List<String> filePaths) {
        LinkedHashMap<String, TipSymbol> symbolMap = new LinkedHashMap<String, TipSymbol>();
        for (String filePath : filePaths) {
            InputStream inputStream = null;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                File file = new File(filePath);
                Document doc = null;
                if (file.exists()) {
                    doc = builder.parse(file);
                } else {
                    inputStream = FileUtils.class.getResourceAsStream(filePath);
                    doc = builder.parse(inputStream);
                }
                NodeList categoryNodes = doc.getElementsByTagName("category");
                for (int i = 0; i < categoryNodes.getLength(); ++i) {
                    Node categoryNode = categoryNodes.item(i);
                    if (categoryNode.getNodeType() != 1) continue;
                    Element categoryElement = (Element)categoryNode;
                    String categoryName = categoryElement.getAttribute("name");
                    NodeList elementNodes = categoryElement.getElementsByTagName("element");
                    for (int j = 0; j < elementNodes.getLength(); ++j) {
                        Node elementNode = elementNodes.item(j);
                        if (elementNode.getNodeType() != 1) continue;
                        Element elementElement = (Element)elementNode;
                        TipSymbol symbol = new TipSymbol();
                        symbol.name = elementElement.getAttribute("name");
                        symbol.label = elementElement.getAttribute("label");
                        symbol.data = elementElement.getAttribute("data");
                        symbol.type = SymbolType.FUNCTION;
                        symbol.categoryName = categoryName;
                        NodeList children = elementElement.getChildNodes();
                        block24: for (int k = 0; k < children.getLength(); ++k) {
                            Node child = children.item(k);
                            if (child.getNodeType() != 1) continue;
                            Element childElement = (Element)child;
                            String content = childElement.getTextContent().trim();
                            switch (childElement.getTagName()) {
                                case "temp": {
                                    symbol.temp = content;
                                    continue block24;
                                }
                                case "tip": {
                                    symbol.tip = content;
                                    continue block24;
                                }
                                case "demo": {
                                    symbol.demo = content;
                                }
                            }
                        }
                        symbolMap.put(symbol.name, symbol);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error parsing XML file: " + filePath);
                e.printStackTrace();
            }
            finally {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return symbolMap;
    }

    public static Map<String, List<TipSymbol>> convertByCategory(Map<String, TipSymbol> data) {
        HashMap<String, List<TipSymbol>> dataList = new HashMap<String, List<TipSymbol>>();
        for (TipSymbol symbol : data.values()) {
            String category;
            String string = category = symbol.categoryName != null ? symbol.categoryName : "Uncategorized";
            if (!dataList.containsKey(category)) {
                dataList.put(category, new ArrayList());
            }
            ((List)dataList.get(category)).add(symbol);
        }
        return dataList;
    }

    public static void loadSymbol() {
        if (mSymbolsList == null) {
            ArrayList<String> symFiles = new ArrayList<String>();
            symFiles.add("/symbol.xml");
            mSymbols = XmlToLuaConverter.parseSymbolXmls(symFiles);
            mSymbolsList = XmlToLuaConverter.convertByCategory(mSymbols);
        }
    }

    public static Map<String, List<TipSymbol>> getSymbolList() {
        XmlToLuaConverter.loadSymbol();
        return mSymbolsList;
    }

    public static TipSymbol getSymbol(String name) {
        XmlToLuaConverter.loadSymbol();
        if (mSymbols != null) {
            return mSymbols.get(name);
        }
        return null;
    }

    public static class TipSymbol {
        public SymbolType type;
        public String name;
        public String label;
        public String tip;
        public String data;
        public String temp;
        public String demo;
        public String categoryName;

        public String toString() {
            return String.format("TipSymbol{name='%s', category='%s', temp='%s'}", this.name, this.categoryName, this.temp);
        }
    }

    public static enum SymbolType {
        FUNCTION,
        GLOBALVAR,
        LOCALVAR,
        UIELEMENT,
        PLUG,
        STATEMENT,
        NONE;

    }
}

