/*
 * Decompiled with CFR 0.152.
 */
package com.nx.nxprojit.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.nx.nxprojit.utils.IInstallResult;
import com.nx.nxprojit.utils.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public class VersionedBinInstaller {
    private static final Logger LOG = Logger.getInstance(VersionedBinInstaller.class);
    private static final String RESOURCE_BIN_DIR = "/bin";
    private static final String VERSION_FILE = "ver";
    private static final String TARGET_DIR_NAME = ".nxproj";

    private void stopOldService() {
        try {
            ArrayList<String> commandList = new ArrayList<String>();
            Path targetDir = this.getTargetDirectory();
            Path lststool = Paths.get(targetDir.toString(), "lrtstool");
            System.out.println(lststool.toString());
            if (SystemInfo.isWindows) {
                commandList.add(lststool.toString() + ".exe");
            } else {
                commandList.add(lststool.toString());
            }
            commandList.add("clean");
            ProcessBuilder processBuilder = new ProcessBuilder(commandList);
            Process process = processBuilder.start();
            process.waitFor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setNdkExecable(String ndkDir) {
    }

    private void installNdk(Project project, IInstallResult r) {
        String property;
        File libgo = new File(project.getBasePath(), "libgo");
        if (libgo.exists() && (property = System.getProperty("user.home")) != null) {
            String osName = System.getProperty("os.name").toLowerCase();
            boolean isWindows = osName.contains("win");
            boolean isMac = osName.contains("mac");
            File ndkDir = new File(property, "ndk");
            File finishtag = new File(ndkDir, "finish.tag");
            if (finishtag.exists()) {
                this.setNdkExecable(ndkDir.getAbsolutePath());
                return;
            }
            try {
                this.deleteDirectory(ndkDir.toPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!isWindows && !isMac) {
                r.updateProgress(0.0, "Unsupported operating system");
                return;
            }
            if (!ndkDir.exists()) {
                r.updateProgress(0.0, "Creating NDK directory...");
                if (!ndkDir.mkdirs()) {
                    r.updateProgress(0.0, "Failed to create NDK directory");
                    return;
                }
            }
            String ndkUrl = isWindows ? "https://dl.google.com/android/repository/android-ndk-r27-windows.zip" : "https://dl.google.com/android/repository/android-ndk-r27-darwin.zip";
            try {
                File tempFile = File.createTempFile("ndk", ".zip");
                r.updateProgress(0.0, "\u6b63\u5728\u4e0b\u8f7dNDK");
                this.downloadFileWithProgress(ndkUrl, tempFile, r);
                r.updateProgress(0.5, "\u89e3\u538bNDK");
                if (isWindows) {
                    this.unzipFileWithoutTopLevelWin(tempFile, ndkDir, r);
                } else {
                    this.unzipFileWithoutTopLevel(tempFile, ndkDir, r);
                }
                tempFile.delete();
                finishtag.createNewFile();
                this.setNdkExecable(ndkDir.getAbsolutePath());
                r.updateProgress(1.0, "Installation complete");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void downloadFileWithProgress(String urlString, File destination, IInstallResult r) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        int fileSize = connection.getContentLength();
        try (BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
             FileOutputStream out = new FileOutputStream(destination);){
            int bytesRead;
            byte[] buffer = new byte[4096];
            long totalBytesRead = 0L;
            while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                double progress = 0.5 * ((double)(totalBytesRead += (long)bytesRead) / (double)fileSize);
                r.updateProgress(progress, String.format("\u4e0b\u8f7dNDK\u8bf7\u7a0d\u7b49 (%.1f%%)", progress * 100.0 * 2.0));
            }
        }
    }

    private void unzipFileWithoutTopLevelWin(File zipFile, File destDir, IInstallResult r) throws IOException {
        byte[] buffer = new byte[1024];
        long totalUncompressedSize = this.getZipFileSize(zipFile);
        long totalExtracted = 0L;
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry zipEntry = zis.getNextEntry();
            if (zipEntry != null && zipEntry.isDirectory()) {
                zipEntry = zis.getNextEntry();
            }
            while (zipEntry != null) {
                String entryName = zipEntry.getName();
                int firstSeparator = entryName.indexOf(47);
                if (firstSeparator > 0) {
                    entryName = entryName.substring(firstSeparator + 1);
                }
                File newFile = new File(destDir, entryName);
                if (zipEntry.isDirectory()) {
                    if (!newFile.isDirectory() && !newFile.mkdirs()) {
                        throw new IOException("Failed to create directory " + newFile);
                    }
                } else {
                    File parent = newFile.getParentFile();
                    if (parent != null && !parent.isDirectory() && !parent.mkdirs()) {
                        throw new IOException("Failed to create directory " + parent);
                    }
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                            double progress = 0.5 + 0.5 * ((double)(totalExtracted += (long)len) / (double)totalUncompressedSize);
                            r.updateProgress(progress, String.format("Extracting... (%.1f%%)", (progress - 0.5) * 100.0 * 2.0));
                        }
                    }
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
        }
    }

    private void unzipFileWithoutTopLevel(File zipFile, File destDir, IInstallResult r) throws IOException {
        int BUFFER_SIZE = 65536;
        byte[] buffer = new byte[65536];
        long totalUncompressedSize = this.calculateUncompressedSize(zipFile);
        long totalExtracted = 0L;
        long lastUpdateTime = System.currentTimeMillis();
        long UPDATE_INTERVAL = 200L;
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));){
            ZipEntry zipEntry = zis.getNextEntry();
            if (zipEntry != null && zipEntry.isDirectory()) {
                zipEntry = zis.getNextEntry();
            }
            while (zipEntry != null) {
                String entryName = zipEntry.getName();
                int firstSeparator = entryName.indexOf(47);
                if (firstSeparator > 0) {
                    entryName = entryName.substring(firstSeparator + 1);
                }
                File newFile = new File(destDir, entryName);
                if (zipEntry.isDirectory()) {
                    if (!newFile.mkdirs() && !newFile.isDirectory()) {
                        throw new IOException("Failed to create directory " + newFile);
                    }
                } else if (this.isSymbolicLink(zipEntry)) {
                    int len;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while ((len = zis.read(buffer)) > 0) {
                        baos.write(buffer, 0, len);
                    }
                    String linkTarget = new String(baos.toByteArray(), StandardCharsets.UTF_8);
                    this.createSymbolicLink(newFile, linkTarget);
                } else {
                    File parent = newFile.getParentFile();
                    if (parent != null && !parent.exists() && !parent.mkdirs()) {
                        throw new IOException("Failed to create directory " + parent);
                    }
                    try (FileOutputStream fos = new FileOutputStream(newFile);
                         BufferedOutputStream bos = new BufferedOutputStream(fos, 65536);){
                        int len;
                        while ((len = zis.read(buffer)) > 0) {
                            bos.write(buffer, 0, len);
                            totalExtracted += (long)len;
                            long currentTime = System.currentTimeMillis();
                            if (currentTime - lastUpdateTime <= 200L) continue;
                            double progress = this.calculateSafeProgress(totalExtracted, totalUncompressedSize);
                            r.updateProgress(progress, String.format("Extracting... (%.1f MB/%.1f MB)", (double)totalExtracted / 1048576.0, (double)totalUncompressedSize / 1048576.0));
                            lastUpdateTime = currentTime;
                        }
                    }
                }
                zipEntry = zis.getNextEntry();
            }
        }
        r.updateProgress(1.0, "Extraction complete");
    }

    private boolean isSymbolicLink(ZipEntry entry) {
        String name;
        byte[] extra;
        if (entry.getExtra() != null && (extra = entry.getExtra()) != null && extra.length >= 4) {
            for (int i = 0; i < extra.length - 1; ++i) {
                if ((extra[i] & 0xFF) != 117 || (extra[i + 1] & 0xFF) != 120 || i + 4 >= extra.length) continue;
                int mode = extra[i + 2] & 0xFF | (extra[i + 3] & 0xFF) << 8;
                return (mode & 0xA000) == 40960;
            }
        }
        if ((name = entry.getName()).contains("->")) {
            return true;
        }
        return entry.getSize() > 0L && entry.getSize() < 1024L;
    }

    private void createSymbolicLink(File linkFile, String target) throws IOException {
        try {
            Path linkPath = linkFile.toPath();
            Path targetPath = Paths.get(target, new String[0]);
            Files.createDirectories(linkPath.getParent(), new FileAttribute[0]);
            Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
        }
        catch (UnsupportedOperationException e) {
            try (FileWriter fw = new FileWriter(linkFile);){
                fw.write(target);
            }
        }
    }

    private double calculateSafeProgress(long extracted, long total) {
        if (total <= 0L) {
            return 0.5 + 0.5 * Math.min(1.0, (double)extracted / 5.24288E8);
        }
        double ratio = Math.min(1.0, (double)extracted / (double)total);
        return 0.5 + 0.5 * ratio;
    }

    private long calculateUncompressedSize(File zipFile) throws IOException {
        long totalSize = 0L;
        try (ZipFile zf = new ZipFile(zipFile);){
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                long size;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || (size = entry.getSize()) <= 0L) continue;
                totalSize += size;
            }
        }
        return totalSize > 0L ? totalSize : -1L;
    }

    private void unzipFileWithProgress(File zipFile, File destDir, IInstallResult r) throws IOException {
        byte[] buffer = new byte[1024];
        long totalUncompressedSize = this.getZipFileSize(zipFile);
        long totalExtracted = 0L;
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File newFile = new File(destDir, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    if (!newFile.isDirectory() && !newFile.mkdirs()) {
                        throw new IOException("Failed to create directory " + newFile);
                    }
                } else {
                    File parent = newFile.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        throw new IOException("Failed to create directory " + parent);
                    }
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                            double progress = 0.5 + 0.5 * ((double)(totalExtracted += (long)len) / (double)totalUncompressedSize);
                            r.updateProgress(progress, String.format("Extracting... (%.1f%%)", (progress - 0.5) * 100.0 * 2.0));
                        }
                    }
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
        }
    }

    private long getZipFileSize(File zipFile) throws IOException {
        long totalSize = 0L;
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                if (!zipEntry.isDirectory()) {
                    totalSize += zipEntry.getSize();
                }
                zipEntry = zis.getNextEntry();
            }
        }
        return totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installIfNeeded(Project project, final IInstallResult r) {
        try {
            Path targetDir = this.getTargetDirectory();
            String resourceVersion = this.getResourceVersion();
            String platformSubDir = this.getPlatformSubDir();
            this.installNdk(project, r);
            Path nxprojDir = Paths.get(targetDir.toString(), "go");
            if (this.shouldInstall(targetDir, resourceVersion)) {
                if (Files.exists(targetDir, new LinkOption[0])) {
                    this.stopOldService();
                    this.deleteDirectory(targetDir);
                }
                Files.createDirectories(targetDir, new FileAttribute[0]);
                String plat = this.getPlatformSubDir();
                this.copyResourcesUsingVfs("/bin/" + plat, r);
                VersionedBinInstaller.extractZipResource("/bin/go" + plat + ".zip", nxprojDir, r);
                Files.write(targetDir.resolve(VERSION_FILE), resourceVersion.getBytes(), new OpenOption[0]);
                LOG.info("Binaries installed/updated to version: " + resourceVersion + " (platform: " + platformSubDir + ")");
            } else {
                LOG.info("Binaries are up-to-date, version: " + resourceVersion);
            }
            Utils.setGoRoot(project, nxprojDir.toString());
            int sPort = -1;
            File rid = null;
            try {
                ArrayList<String> commandList = new ArrayList<String>();
                Path lststool = Paths.get(targetDir.toString(), "lrtstool");
                System.out.println(lststool.toString());
                if (SystemInfo.isWindows) {
                    commandList.add(lststool.toString() + ".exe");
                } else {
                    commandList.add(lststool.toString());
                }
                rid = new File(targetDir.toString() + "/" + UUID.randomUUID());
                if (rid.exists()) {
                    rid.delete();
                }
                commandList.add(rid.getAbsolutePath());
                ProcessBuilder processBuilder = new ProcessBuilder(commandList);
                Process process = processBuilder.start();
                process.waitFor();
                if (!rid.exists()) {
                    Utils.runMainThread(new Runnable(){

                        @Override
                        public void run() {
                            r.installFailed("\u542f\u52a8\u670d\u52a1\u5931\u8d25");
                        }
                    });
                    return;
                }
                String ret = Utils.readFileToString(rid.getAbsolutePath(), StandardCharsets.UTF_8);
                JSONObject o = new JSONObject(ret);
                sPort = o.getInt("port");
            }
            catch (Exception e) {
                Utils.runMainThread(new Runnable(){

                    @Override
                    public void run() {
                        r.installFailed("\u542f\u52a8\u670d\u52a1\u5931\u8d25:" + e.toString());
                    }
                });
                return;
            }
            finally {
                if (rid != null && rid.exists()) {
                    rid.delete();
                }
            }
            final int myPort = sPort;
            Utils.runMainThread(new Runnable(){

                @Override
                public void run() {
                    r.installSuccess(myPort);
                }
            });
        }
        catch (Exception e) {
            LOG.error("Failed to install/check binaries", (Throwable)e);
            Utils.runMainThread(new Runnable(){

                @Override
                public void run() {
                    r.installFailed(e.toString());
                }
            });
        }
    }

    @NotNull
    private String getPlatformSubDir() {
        if (SystemInfo.isWindows) {
            return "win";
        }
        if (SystemInfo.isMac) {
            return "mac";
        }
        if (SystemInfo.isLinux) {
            return "mac";
        }
        throw new UnsupportedOperationException("Unsupported platform");
    }

    @Nullable
    private String getResourceVersion() throws IOException {
        URL versionFileUrl = this.getClass().getResource("/bin/ver");
        if (versionFileUrl == null) {
            throw new FileNotFoundException("Version file not found in resources");
        }
        try (InputStream in = versionFileUrl.openStream();){
            String string = new String(in.readAllBytes()).trim();
            return string;
        }
    }

    @NotNull
    private Path getTargetDirectory() {
        String property = System.getProperty("user.home");
        if (property == null || property.length() <= 0) {
            property = System.getProperty("java.io.tmpdir");
        }
        Path path = Paths.get(System.getProperty("user.home"), TARGET_DIR_NAME);
        if (path == null) {
            VersionedBinInstaller.$$$reportNull$$$0(0);
        }
        return path;
    }

    private boolean shouldInstall(@NotNull Path targetDir, @Nullable String resourceVersion) throws IOException {
        boolean ret;
        if (targetDir == null) {
            VersionedBinInstaller.$$$reportNull$$$0(1);
        }
        if (!Files.exists(targetDir, new LinkOption[0])) {
            return true;
        }
        Path targetVersionFile = targetDir.resolve(VERSION_FILE);
        if (!Files.exists(targetVersionFile, new LinkOption[0])) {
            return true;
        }
        String installedVersion = new String(Files.readAllBytes(targetVersionFile)).trim();
        boolean bl = ret = !installedVersion.equals(resourceVersion);
        if (ret) {
            // empty if block
        }
        return ret;
    }

    public void copyResourcesUsingVfs(String path, final IInstallResult ir) throws IOException {
        URL url = this.getClass().getResource(path);
        if (url == null) {
            return;
        }
        final VirtualFile virtualFile = VfsUtil.findFileByURL((URL)url);
        if (virtualFile == null) {
            return;
        }
        final Path target = this.getTargetDirectory();
        final VirtualFile baseDir = virtualFile.getParent().getParent();
        if (virtualFile.isDirectory()) {
            final int[] totalFiles = new int[]{0};
            final int[] copiedFiles = new int[]{0};
            VfsUtil.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (!file.isDirectory()) {
                        totalFiles[0] = totalFiles[0] + 1;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/nx/nxprojit/utils/VersionedBinInstaller$5", "visitFile"));
                }
            });
            VfsUtil.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    if (!file.isDirectory()) {
                        String relativePath = VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)baseDir);
                        String targetRelativePath = VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)virtualFile);
                        if (targetRelativePath != null) {
                            String targetFile = new File(target.toFile(), targetRelativePath).getAbsolutePath();
                            VersionedBinInstaller.copyTo(relativePath, targetFile);
                            copiedFiles[0] = copiedFiles[0] + 1;
                            double progress = 0.5 * (double)((float)copiedFiles[0] * 1.0f / (float)totalFiles[0]);
                            ir.updateProgress(progress, "\u62f7\u8d1d " + file.getName() + " (" + copiedFiles[0] + "/" + totalFiles[0] + ")");
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/nx/nxprojit/utils/VersionedBinInstaller$6", "visitFile"));
                }
            });
        } else {
            System.out.println("Resource: " + virtualFile.getCanonicalFile());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean extractZipResource(String resourcePath, Path targetDir, IInstallResult ir) throws Exception {
        if (!((String)resourcePath).startsWith("/")) {
            resourcePath = "/" + (String)resourcePath;
        }
        try (InputStream inputStream = VersionedBinInstaller.class.getResourceAsStream((String)resourcePath);){
            if (inputStream == null) {
                LOG.error("ZIP resource not found: " + (String)resourcePath);
                boolean bl2 = false;
                return bl2;
            }
            byte[] zipBytes = IOUtils.toByteArray((InputStream)inputStream);
            int total = 0;
            try (ZipInputStream zipIn = new ZipInputStream(new ByteArrayInputStream(zipBytes));){
                ZipEntry entry = zipIn.getNextEntry();
                while (entry != null) {
                    ++total;
                    zipIn.closeEntry();
                    entry = zipIn.getNextEntry();
                }
            }
            Files.createDirectories(targetDir, new FileAttribute[0]);
            int count = 0;
            try (ZipInputStream zipIn = new ZipInputStream(new ByteArrayInputStream(zipBytes));){
                ZipEntry entry = zipIn.getNextEntry();
                while (entry != null) {
                    Path filePath = targetDir.resolve(entry.getName());
                    if (!entry.isDirectory()) {
                        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                        try (OutputStream out = Files.newOutputStream(filePath, new OpenOption[0]);){
                            IOUtils.copy((InputStream)zipIn, (OutputStream)out);
                        }
                        VersionedBinInstaller.setExecutableIfNeeded(filePath);
                        double progress = 0.5 + 0.5 * (double)((float)count * 1.0f / (float)total);
                        ir.updateProgress(progress, "\u62f7\u8d1d " + entry.getName() + " (" + count + "/" + total + ")");
                        ++count;
                    } else {
                        Files.createDirectories(filePath, new FileAttribute[0]);
                    }
                    zipIn.closeEntry();
                    entry = zipIn.getNextEntry();
                }
            }
            LOG.info("Successfully extracted " + (String)resourcePath + " to " + targetDir);
            boolean bl = true;
            return bl;
        }
    }

    public static boolean copyTo(String target, String str2) {
        InputStream resourceAsStream;
        if (!((String)target).startsWith("/")) {
            target = "/" + (String)target;
        }
        if ((resourceAsStream = VersionedBinInstaller.class.getResourceAsStream((String)target)) == null) {
            System.out.println("copyTo failed1: " + (String)target);
            return false;
        }
        File file = new File(str2);
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        FileOutputStream fileOutputStream = null;
        try {
            boolean ret;
            try {
                fileOutputStream = new FileOutputStream(file);
                IOUtils.copy((InputStream)resourceAsStream, (OutputStream)fileOutputStream);
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
            }
            boolean bl = ret = file.exists() && file.length() > 0L;
            if (ret) {
                VersionedBinInstaller.setExecutableIfNeeded(file.toPath());
            }
            return ret;
        }
        catch (Throwable th) {
            IOUtils.closeQuietly(fileOutputStream);
            throw th;
        }
    }

    private static void setExecutableIfNeeded(Path file) {
        if (!SystemInfo.isWindows) {
            try {
                HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
                perms.add(PosixFilePermission.OWNER_READ);
                perms.add(PosixFilePermission.OWNER_WRITE);
                perms.add(PosixFilePermission.OWNER_EXECUTE);
                perms.add(PosixFilePermission.GROUP_READ);
                perms.add(PosixFilePermission.GROUP_EXECUTE);
                perms.add(PosixFilePermission.OTHERS_READ);
                perms.add(PosixFilePermission.OTHERS_EXECUTE);
                Files.setPosixFilePermissions(file, perms);
            }
            catch (IOException e) {
                LOG.warn("Failed to set executable permissions for: " + file, (Throwable)e);
            }
        }
    }

    private void deleteDirectory(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
                walk.sorted(Comparator.reverseOrder()).forEach(file -> {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to delete: " + file, (Throwable)e);
                    }
                });
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/nx/nxprojit/utils/VersionedBinInstaller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDirectory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/nx/nxprojit/utils/VersionedBinInstaller";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldInstall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

