/*
 * Decompiled with CFR 0.152.
 */
package com.nx.nxprojit.utils;

import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkImpl;
import com.goide.sdk.GoSdkService;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.nx.nxprojit.action.LogConsole;
import com.nx.nxprojit.utils.FileUtils;
import com.nx.nxprojit.utils.ProjectConfigGenerator;
import com.nx.nxprojit.utils.VersionedBinInstaller;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;

public class Utils {
    public static int PROJECT_TYPE = 0;
    public static String PACKAGE_NAME = "";
    private static final String UI_JSON_PATH = "/ui.json";
    private static final Key<LogConsole> CONSOLEVIEW_KEY = Key.create((String)"CONSOLE_VIEW");
    private static final String NOTIFICATION_GROUP = "Plugin Notifications";
    private static Map<String, JsonObject> uiComponentsByName;

    public static void setConsole(Project project, LogConsole v) {
        project.putUserData(CONSOLEVIEW_KEY, (Object)v);
    }

    public static void println(Project project, String log) {
        Utils.println(project, 0, "", -1, log);
    }

    public static void printError(Project project, String log) {
        Utils.println(project, 1, "", -1, log);
    }

    public static void println(Project project, int level, String path, int line, String log) {
        Runnable runnable = () -> {
            LogConsole consoleView = (LogConsole)project.getUserData(CONSOLEVIEW_KEY);
            if (consoleView != null) {
                consoleView.printInfo(project, level, path, line, log);
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable);
        }
    }

    public static void runMainThread(Runnable r) {
        if (r != null) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                r.run();
            } else {
                ApplicationManager.getApplication().invokeLater(r);
            }
        }
    }

    public static void clearConsole(Project project) {
        LogConsole consoleView = (LogConsole)project.getUserData(CONSOLEVIEW_KEY);
        if (consoleView != null) {
            consoleView.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, JsonObject> loadUiComponents() {
        if (uiComponentsByName != null) {
            return uiComponentsByName;
        }
        uiComponentsByName = new HashMap<String, JsonObject>();
        try (InputStream inputStream = Utils.class.getResourceAsStream(UI_JSON_PATH);){
            if (inputStream == null) {
                Map<String, JsonObject> map = uiComponentsByName;
                return map;
            }
            JsonArray jsonArray = JsonParser.parseReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8)).getAsJsonArray();
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject component = jsonArray.get(i).getAsJsonObject();
                String name = component.get("name").getAsString();
                uiComponentsByName.put(name, component);
                ++i;
            }
            return uiComponentsByName;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uiComponentsByName;
    }

    public static String getModuleRootPath(ModifiableRootModel modifiableRootModel) {
        File file = new File(modifiableRootModel.getProject().getBasePath(), modifiableRootModel.getModule().getName());
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
        if (!file.exists()) {
            file.mkdir();
        }
        return file.getAbsolutePath();
    }

    public static File getRootPath(ModifiableRootModel modifiableRootModel) {
        return new File(new File(modifiableRootModel.getProject().getBasePath(), modifiableRootModel.getModule().getName()).getAbsolutePath());
    }

    public static void createProject(ModifiableRootModel modifiableRootModel) {
        if (modifiableRootModel == null) {
            return;
        }
        try {
            String[] subDirs;
            Project project = modifiableRootModel.getProject();
            String projectBasePath = project.getBasePath();
            String projectName = project.getName();
            for (String dir : subDirs = new String[]{"\u811a\u672c", "\u63d2\u4ef6", "\u8d44\u6e90", "\u754c\u9762"}) {
                File dirFile = new File(projectBasePath, dir);
                if (dirFile.exists()) continue;
                dirFile.mkdirs();
            }
            if (PROJECT_TYPE == 1) {
                File libgo = new File(projectBasePath + "/libgo");
                if (!libgo.exists()) {
                    libgo.mkdirs();
                }
                Utils.extractZipResource("/template/libgo.zip", libgo.toPath());
            }
            if (PROJECT_TYPE == 0) {
                FileUtils.copyResourceToFile("/template/template.lua", new File(projectBasePath + "/\u811a\u672c", projectName + ".lua"));
            } else if (PROJECT_TYPE == 1) {
                FileUtils.copyResourceToFile("/template/templatego.lua", new File(projectBasePath + "/\u811a\u672c", projectName + ".lua"));
            }
            FileUtils.copyResourceToFile("/template/template.ui", new File(projectBasePath + "/\u754c\u9762", projectName + ".ui"));
            FileUtils.copyResourceToFile("/template/template.rc", new File(projectBasePath + "/\u8d44\u6e90", projectName + ".rc"));
            VirtualFile projectRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(projectBasePath);
            if (projectRoot != null) {
                for (ContentEntry entry : modifiableRootModel.getContentEntries()) {
                    modifiableRootModel.removeContentEntry(entry);
                }
                ContentEntry contentEntry = modifiableRootModel.addContentEntry(projectRoot);
                if (contentEntry != null) {
                    for (String dir : subDirs) {
                        VirtualFile sourceDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(new File(projectBasePath, dir).getAbsolutePath());
                        if (sourceDir == null) continue;
                        contentEntry.addSourceFolder(sourceDir, false);
                    }
                }
            }
            try {
                String pname = projectBasePath + "/" + projectName + ".lcprojit";
                File outputFile = new File(pname);
                String pkgName = PACKAGE_NAME;
                if (pkgName == null || pkgName.isEmpty()) {
                    pkgName = "com.test";
                }
                ProjectConfigGenerator.generateProjectConfig(PACKAGE_NAME, projectName, outputFile);
                System.out.println("\u914d\u7f6e\u6587\u4ef6\u5df2\u751f\u6210: " + outputFile.getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String moduleName = modifiableRootModel.getModule().getName();
            String moduleFilePath = new File(projectBasePath, moduleName + ".iml").getAbsolutePath();
            modifiableRootModel.getModule().getModuleFile().getParent().refresh(false, true);
            LocalFileSystem.getInstance().refresh(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String findFirstLcprojitFile(File directory) {
        if (!directory.isDirectory()) {
            return null;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return null;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                String result = Utils.findFirstLcprojitFile(file);
                if (result == null) continue;
                return result;
            }
            if (!file.getName().toLowerCase().endsWith(".lcprojit")) continue;
            return file.getAbsolutePath();
        }
        return null;
    }

    public static void showUiTooltipNotification(String itemName) {
        Notification notification = new Notification(NOTIFICATION_GROUP, "\u590d\u5236\u6210\u529f", "\u7ec4\u4ef6 [" + itemName + "] \u7684\u914d\u7f6e\u5df2\u590d\u5236\u5230\u526a\u8d34\u677f", NotificationType.INFORMATION);
        Notifications.Bus.notify((Notification)notification);
    }

    public static void showTooltipNotification(String msg) {
        Notification notification = new Notification(NOTIFICATION_GROUP, msg, NotificationType.INFORMATION);
        Notifications.Bus.notify((Notification)notification);
    }

    public static String readFileToString(String filePath, Charset charset) throws IOException {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), charset));){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line).append(System.lineSeparator());
            }
        }
        return content.toString().trim();
    }

    public static void updateIde(Project project) {
        if (FileEditorManager.getInstance((Project)project).getSelectedTextEditor() != null) {
            FileEditorManager.getInstance((Project)project).getSelectedTextEditor().getContentComponent().requestFocus();
        }
    }

    public static void setGoRoot(final Project project, final String sdkPath) {
        Utils.runMainThread(new Runnable(){

            @Override
            public void run() {
                GoSdkService.getInstance((Project)project).setSdk((GoSdk)new GoSdkImpl("file://" + sdkPath, "1.24.2", sdkPath + "/src/internal/runtime/sys/zversion.go"), true);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean extractZipResource(String resourcePath, Path targetDir) throws Exception {
        if (!((String)resourcePath).startsWith("/")) {
            resourcePath = "/" + (String)resourcePath;
        }
        try (InputStream inputStream = VersionedBinInstaller.class.getResourceAsStream((String)resourcePath);){
            if (inputStream == null) {
                boolean bl2 = false;
                return bl2;
            }
            byte[] zipBytes = IOUtils.toByteArray((InputStream)inputStream);
            int total = 0;
            try (ZipInputStream zipIn = new ZipInputStream(new ByteArrayInputStream(zipBytes));){
                ZipEntry entry = zipIn.getNextEntry();
                while (entry != null) {
                    ++total;
                    zipIn.closeEntry();
                    entry = zipIn.getNextEntry();
                }
            }
            Files.createDirectories(targetDir, new FileAttribute[0]);
            int count = 0;
            try (ZipInputStream zipIn = new ZipInputStream(new ByteArrayInputStream(zipBytes));){
                ZipEntry entry = zipIn.getNextEntry();
                while (entry != null) {
                    Path filePath = targetDir.resolve(entry.getName());
                    if (!entry.isDirectory()) {
                        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                        try (OutputStream out = Files.newOutputStream(filePath, new OpenOption[0]);){
                            IOUtils.copy((InputStream)zipIn, (OutputStream)out);
                        }
                        ++count;
                    } else {
                        Files.createDirectories(filePath, new FileAttribute[0]);
                    }
                    zipIn.closeEntry();
                    entry = zipIn.getNextEntry();
                }
            }
            boolean bl = true;
            return bl;
        }
    }
}

