/*
 * Decompiled with CFR 0.152.
 */
package com.nx.nxprojit.utils;

import com.google.gson.JsonObject;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.nx.nxprojit.utils.Utils;
import java.io.File;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.json.JSONObject;

public class ScriptMgr {
    private static final ScriptMgr instance = new ScriptMgr();
    private final ConcurrentHashMap<Project, AtomicBoolean> bRunning = new ConcurrentHashMap();
    private final ConcurrentHashMap<Project, WebSocketClient> webSocketClientMap = new ConcurrentHashMap();

    public static ScriptMgr getInstance() {
        return instance;
    }

    public void init(final Project project, int port) {
        URI uri;
        if (project == null || project.getBasePath() == null) {
            Utils.showTooltipNotification("\u9879\u76ee\u4e3a\u7a7a\u65e0\u6cd5\u52a0\u8f7d");
            return;
        }
        final String projfile = Utils.findFirstLcprojitFile(new File(project.getBasePath()));
        if (projfile == null) {
            Utils.showTooltipNotification("\u52a0\u8f7d\u7684\u4e0d\u662f\u6709\u6548\u7684\u61d2\u4eba\u9879\u76ee");
            return;
        }
        try {
            uri = new URI(String.format("ws://127.0.0.1:%d", port));
        }
        catch (Exception ex) {
            return;
        }
        WebSocketClient oldClient = this.webSocketClientMap.get(project);
        if (oldClient != null) {
            oldClient.close();
        }
        WebSocketClient webSocketClient = new WebSocketClient(uri){

            public void onOpen(ServerHandshake handshakedata) {
                ScriptMgr.this.webSocketClientMap.compute(project, (k, existing) -> existing == this || existing == null ? this : existing);
                ScriptMgr.this.openProject(project, projfile);
            }

            public void onMessage(String message) {
                try {
                    JSONObject obj = new JSONObject(message);
                    int what = obj.getInt("what");
                    if (what == 258) {
                        ScriptMgr.this.onStopScript(project, null);
                    } else if (what == 259) {
                        String msg = obj.getString("msg");
                        ScriptMgr.this.onStopScript(project, msg);
                    } else if (what == 265) {
                        String msg = obj.getString("msg");
                        int level = obj.getInt("level");
                        int line = obj.getInt("line");
                        String path = obj.getString("path");
                        Utils.println(project, level, path, line, msg);
                    } else if (what == 256) {
                        Utils.runMainThread(new Runnable(){

                            @Override
                            public void run() {
                                LocalFileSystem.getInstance().refresh(true);
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void onClose(int code, String reason, boolean remote) {
                ScriptMgr.this.webSocketClientMap.computeIfPresent(project, (k, existing) -> existing == this ? null : existing);
                ScriptMgr.this.stopScript(project);
            }

            public void onError(Exception ex) {
            }
        };
        webSocketClient.connect();
    }

    public void startScript(Project project) {
        if (project == null) {
            return;
        }
        WebSocketClient client = this.webSocketClientMap.get(project);
        if (client != null && this.isConnected(project) && this.bRunning.computeIfAbsent(project, k -> new AtomicBoolean(false)).compareAndSet(false, true)) {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("\u61d2\u4eba\u65e5\u5fd7");
            if (toolWindow != null && !toolWindow.isVisible()) {
                toolWindow.activate(null);
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            Utils.clearConsole(project);
            Utils.println(project, "\u811a\u672c\u5f00\u59cb\u8fd0\u884c");
            this.sendMessage(client, 257, project.getBasePath());
        }
    }

    private void onStopScript(final Project project, final String err) {
        System.out.println("===onStopScript==");
        Utils.runMainThread(new Runnable(){

            @Override
            public void run() {
                AtomicBoolean runningFlag = ScriptMgr.this.bRunning.get(project);
                if (runningFlag != null) {
                    if (err != null && !err.isEmpty()) {
                        Utils.printError(project, err);
                    }
                    Utils.println(project, "\u811a\u672c\u505c\u6b62\u8fd0\u884c");
                    runningFlag.set(false);
                }
            }
        });
    }

    public void stopScript(Project project) {
        if (project == null) {
            return;
        }
        WebSocketClient client = this.webSocketClientMap.get(project);
        if (client != null) {
            this.sendMessage(client, 258, project.getBasePath());
        }
    }

    public boolean isRunning(Project project) {
        if (project == null) {
            return false;
        }
        AtomicBoolean runningFlag = this.bRunning.get(project);
        return runningFlag != null && runningFlag.get();
    }

    public boolean isConnected(Project project) {
        if (project == null) {
            return false;
        }
        WebSocketClient client = this.webSocketClientMap.get(project);
        return client != null && client.isOpen();
    }

    private void sendMessage(WebSocketClient cli, int what, String message) {
        if (cli != null) {
            try {
                JsonObject o = new JsonObject();
                o.addProperty("what", (Number)what);
                if (message != null) {
                    o.addProperty("msg", message);
                }
                cli.send(o.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void openProject(Project project, String projfile) {
        if (project == null) {
            return;
        }
        WebSocketClient client = this.webSocketClientMap.get(project);
        if (client != null && this.isConnected(project)) {
            this.sendMessage(client, 256, projfile);
            return;
        }
    }

    public void showUI(Project project, String uifile) {
        if (project == null) {
            return;
        }
        WebSocketClient client = this.webSocketClientMap.get(project);
        if (client != null && this.isConnected(project)) {
            this.sendMessage(client, 267, uifile);
            return;
        }
    }

    public void showPluginGen(Project project, String luafile) {
        if (project == null) {
            return;
        }
        WebSocketClient client = this.webSocketClientMap.get(project);
        if (client != null && this.isConnected(project)) {
            this.sendMessage(client, 268, luafile);
            return;
        }
    }

    public void setTheme(Project project, int type) {
        if (project == null) {
            return;
        }
        WebSocketClient client = this.webSocketClientMap.get(project);
        if (client != null && this.isConnected(project)) {
            JSONObject obj = new JSONObject();
            try {
                obj.put("type", type);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sendMessage(client, 269, obj.toString());
            return;
        }
    }

    public void openConnectDevTool(Project project) {
        this.executeCmd(260, project);
    }

    public void showTsWindow(Project project) {
        this.executeCmd(261, project);
    }

    public void showPublishDlg(Project project) {
        this.executeCmd(262, project);
    }

    public void showLogin(Project project) {
        this.executeCmd(263, project);
    }

    public void showSettings(Project project) {
        this.executeCmd(266, project);
    }

    public void showLookupApp(Project project) {
        this.executeCmd(264, project);
    }

    private boolean executeCmd(int msg, Project project) {
        if (project == null) {
            return false;
        }
        WebSocketClient client = this.webSocketClientMap.get(project);
        if (client != null && this.isConnected(project)) {
            this.sendMessage(client, msg, project.getBasePath());
            return true;
        }
        return false;
    }
}

