/*
 * Decompiled with CFR 0.152.
 */
package com.nx.nxprojit.utils;

import java.io.File;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectConfigGenerator {
    public static void generateProjectConfig(String packageName, String projectName, File outputFile) throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement("lcprojit");
        rootElement.setAttribute("projname", projectName);
        rootElement.setAttribute("lcprojversion", "150");
        rootElement.setAttribute("is_acc_mode", "0");
        rootElement.setAttribute("appname", projectName);
        rootElement.setAttribute("pkgname", packageName);
        doc.appendChild(rootElement);
        ProjectConfigGenerator.addEntryElement(doc, rootElement, "lua", projectName + ".lua");
        ProjectConfigGenerator.addEntryElement(doc, rootElement, "ui", projectName + ".ui");
        ProjectConfigGenerator.addEntryElement(doc, rootElement, "rc", projectName + ".rc");
        Element luaej = doc.createElement("luaej");
        rootElement.appendChild(luaej);
        ProjectConfigGenerator.writeXmlDocument(doc, outputFile);
    }

    private static void addEntryElement(Document doc, Element parent, String tagName, String entryValue) {
        Element element = doc.createElement(tagName);
        element.setAttribute("entry", entryValue);
        parent.appendChild(element);
    }

    private static void writeXmlDocument(Document doc, File outputFile) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(outputFile);
        transformer.transform(source, result);
    }
}

