/*
 * Decompiled with CFR 0.152.
 */
package com.nx.nxprojit.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;

public class FileUtils {
    private static final String TEMP_DIR = File.separator + "fd" + File.separator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readResourceAsString(String resourcePath) {
        InputStream inputStream = null;
        try {
            inputStream = FileUtils.class.getResourceAsStream(resourcePath);
            String string = FileUtils.readStreamAsString(inputStream, StandardCharsets.UTF_8.name());
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            FileUtils.closeQuietly(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyResourceToFile(String resourcePath, File destFile) {
        boolean bl;
        InputStream inputStream = null;
        if (destFile.exists()) {
            destFile.delete();
        }
        try {
            destFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileOutputStream fileOutputStream = null;
        try {
            if (!((String)resourcePath).startsWith("/")) {
                resourcePath = "/" + (String)resourcePath;
            }
            inputStream = FileUtils.class.getResourceAsStream((String)resourcePath);
            fileOutputStream = new FileOutputStream(destFile);
            FileUtils.copyStream(inputStream, fileOutputStream);
            bl = destFile.length() > 0L;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(inputStream);
                FileUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
            FileUtils.closeQuietly(inputStream);
            FileUtils.closeQuietly(fileOutputStream);
            return bl2;
        }
        FileUtils.closeQuietly(inputStream);
        FileUtils.closeQuietly(fileOutputStream);
        return bl;
    }

    public static byte[] readStreamToBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtils.copyStream(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static int copyStream(InputStream input, OutputStream output) throws IOException {
        long bytesCopied = FileUtils.copyStreamLarge(input, output);
        if (bytesCopied > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)bytesCopied;
    }

    public static long copyStreamLarge(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        long count = 0L;
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
            count += (long)bytesRead;
        }
        return count;
    }

    public static String readStreamAsString(InputStream input) throws IOException {
        if (input == null) {
            return null;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        FileUtils.copyStream(input, result);
        return result.toString();
    }

    public static String readStreamAsString(InputStream input, String charsetName) throws IOException {
        if (input == null) {
            return null;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        FileUtils.copyStream(input, result);
        return result.toString(charsetName);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void moveFile(File source, File dest) {
        if (source == null || dest == null) {
            return;
        }
        FileChannel inputChannel = null;
        FileChannel outputChannel = null;
        try {
            outputChannel = new FileOutputStream(dest).getChannel();
            inputChannel = new FileInputStream(source).getChannel();
            inputChannel.transferTo(0L, inputChannel.size(), outputChannel);
            source.delete();
        }
        catch (IOException iOException) {
            FileUtils.closeQuietly(inputChannel);
            FileUtils.closeQuietly(outputChannel);
            catch (Throwable throwable) {
                FileUtils.closeQuietly(inputChannel);
                FileUtils.closeQuietly(outputChannel);
                throw throwable;
            }
        }
        FileUtils.closeQuietly(inputChannel);
        FileUtils.closeQuietly(outputChannel);
    }

    public static boolean copyDirectory(String sourceDir, String destDir) {
        File source = new File(sourceDir);
        File dest = new File(destDir);
        String[] files = source.list();
        if (!dest.exists()) {
            dest.mkdir();
        }
        for (String file : files) {
            File srcFile = new File(source, file);
            File destFile = new File(dest, file);
            if (!(srcFile.isDirectory() ? !FileUtils.copyDirectory(srcFile.getAbsolutePath(), destFile.getAbsolutePath()) : !FileUtils.copyFile(srcFile.getAbsolutePath(), destFile.getAbsolutePath()))) continue;
            return false;
        }
        return true;
    }

    public static boolean copyFile(String sourcePath, String destPath) {
        try {
            File sourceFile = new File(sourcePath);
            File destFile = new File(destPath);
            if (sourceFile.length() > 0L) {
                FileUtils.copyFileWithChannel(sourceFile, destFile);
                return destFile.exists() && destFile.length() > 0L;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void copyFileWithChannel(File source, File dest) {
        if (source == null || dest == null) {
            return;
        }
        FileChannel inputChannel = null;
        FileChannel outputChannel = null;
        try {
            outputChannel = new FileOutputStream(dest).getChannel();
            inputChannel = new FileInputStream(source).getChannel();
            inputChannel.transferTo(0L, inputChannel.size(), outputChannel);
        }
        catch (IOException iOException) {
            FileUtils.closeQuietly(inputChannel);
            FileUtils.closeQuietly(outputChannel);
            catch (Throwable throwable) {
                FileUtils.closeQuietly(inputChannel);
                FileUtils.closeQuietly(outputChannel);
                throw throwable;
            }
        }
        FileUtils.closeQuietly(inputChannel);
        FileUtils.closeQuietly(outputChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(File file) {
        String string;
        if (file == null) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            string = FileUtils.readStreamAsString(fis);
        }
        catch (IOException e) {
            String string2;
            try {
                string2 = null;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fis);
                throw throwable;
            }
            FileUtils.closeQuietly(fis);
            return string2;
        }
        FileUtils.closeQuietly(fis);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToBytes(File file) {
        byte[] byArray;
        if (file == null) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            FileUtils.copyStream(fis, bos);
            byArray = bos.toByteArray();
        }
        catch (IOException e) {
            byte[] byArray2;
            try {
                byArray2 = null;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fis);
                throw throwable;
            }
            FileUtils.closeQuietly(fis);
            return byArray2;
        }
        FileUtils.closeQuietly(fis);
        return byArray;
    }

    public static void createDirIfNotExists(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static void deleteRecursive(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
                return;
            }
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    FileUtils.deleteRecursive(child);
                }
            }
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytesToFile(File file, byte[] data) {
        if (file == null || data == null) {
            return;
        }
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fos = null;
        try {
            file.createNewFile();
            fos = new FileOutputStream(file);
            fos.write(data);
            fos.flush();
        }
        catch (IOException iOException) {
            FileUtils.closeQuietly(fos);
        }
        catch (Throwable throwable) {
            FileUtils.closeQuietly(fos);
            throw throwable;
        }
        FileUtils.closeQuietly(fos);
    }

    public static void writeStringToFile(File file, String content) {
        FileUtils.writeStringToFile(file, content, StandardCharsets.UTF_8.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void writeStringToFile(File file, String content, String charsetName) {
        if (file == null || content == null) {
            return;
        }
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fos = null;
        try {
            file.createNewFile();
            fos = new FileOutputStream(file);
            fos.write(content.getBytes(charsetName));
            fos.flush();
        }
        catch (IOException iOException) {
            FileUtils.closeQuietly(fos);
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        FileUtils.closeQuietly(fos);
    }

    public static String getStackTraceAsString(Exception e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        e.printStackTrace(pw);
        pw.close();
        try {
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toString();
    }
}

