/*
 * Decompiled with CFR 0.152.
 */
package com.nx.nxprojit.utils;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.nx.nxprojit.utils.IInstallResult;
import com.nx.nxprojit.utils.ScriptMgr;
import com.nx.nxprojit.utils.Utils;
import com.nx.nxprojit.utils.VersionedBinInstaller;
import com.nx.nxprojit.utils.XmlToLuaConverter;
import org.jetbrains.annotations.NotNull;

public class CoreService {
    private VersionedBinInstaller installer;
    private boolean isTasking = false;
    public static final CoreService sInstance = new CoreService();

    public boolean enable(Project project) {
        if (project != null) {
            boolean connected = ScriptMgr.getInstance().isConnected(project);
            return !this.isTasking && !connected;
        }
        return false;
    }

    public synchronized void start(final Project project) {
        if (this.isTasking) {
            return;
        }
        this.isTasking = true;
        if (this.installer == null) {
            this.installer = new VersionedBinInstaller();
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "\u521d\u59cb\u5316\u9879\u76ee"){

            public void run(final @NotNull ProgressIndicator progressIndicator) {
                if (progressIndicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                CoreService.this.installer.installIfNeeded(project, new IInstallResult(){

                    @Override
                    public void installSuccess(int port) {
                        ScriptMgr.getInstance().init(project, port);
                        XmlToLuaConverter.loadSymbol();
                        LocalFileSystem.getInstance().refresh(true);
                        Utils.showTooltipNotification("\u521d\u59cb\u5316\u5b8c\u6210");
                        CoreService.this.isTasking = false;
                    }

                    @Override
                    public void installFailed(String err) {
                        CoreService.this.isTasking = false;
                        Utils.showTooltipNotification("\u521d\u59cb\u5316\u5931\u8d25:" + err);
                    }

                    @Override
                    public void updateProgress(double fraction, String message) {
                        progressIndicator.setFraction(fraction);
                        progressIndicator.setText(message);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/nx/nxprojit/utils/CoreService$1", "run"));
            }
        });
    }
}

