/*
 * Decompiled with CFR 0.152.
 */
package com.nx.nxprojit.module;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.JViewport;

public class WrapLayout
extends FlowLayout {
    public WrapLayout() {
    }

    public WrapLayout(int align) {
        super(align);
    }

    public WrapLayout(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this.layoutSize(target, true);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.layoutSize(target, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension layoutSize(Container target, boolean preferred) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int availableWidth = this.getAvailableWidth(target);
            if (availableWidth <= 0) {
                availableWidth = target.getWidth();
            }
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            Insets insets = target.getInsets();
            int maxWidth = availableWidth - (insets.left + insets.right + hgap * 2);
            Dimension dim = new Dimension(0, 0);
            int rowWidth = 0;
            int rowHeight = 0;
            for (Component m : target.getComponents()) {
                Dimension d;
                if (!m.isVisible()) continue;
                Dimension dimension = d = preferred ? m.getPreferredSize() : m.getMinimumSize();
                if (rowWidth + d.width + hgap > maxWidth) {
                    dim.width = Math.max(dim.width, rowWidth);
                    dim.height += rowHeight + vgap;
                    rowWidth = 0;
                    rowHeight = 0;
                }
                if (rowWidth != 0) {
                    rowWidth += hgap;
                }
                rowWidth += d.width;
                rowHeight = Math.max(rowHeight, d.height);
            }
            dim.width = Math.max(dim.width, rowWidth);
            dim.height += rowHeight;
            dim.width += insets.left + insets.right + hgap * 2;
            dim.height += insets.top + insets.bottom + vgap * 2;
            return dim;
        }
    }

    private int getAvailableWidth(Container target) {
        Container parent = target.getParent();
        if (parent instanceof JViewport) {
            return parent.getWidth();
        }
        if (target.getWidth() > 0) {
            return target.getWidth();
        }
        if (parent != null) {
            return parent.getWidth();
        }
        return target.getWidth();
    }
}

