/*
 * Decompiled with CFR 0.152.
 */
package com.nx.nxprojit.module;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LargeFileWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.nx.nxprojit.module.WrapLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileSystemView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RcFileEditor
implements FileEditor {
    private static final int ICON_SIZE = 50;
    private static final int PADDING = 5;
    private static final Color SELECTION_COLOR = new Color(51, 153, 255);
    private static final Color HOVER_COLOR = new Color(229, 241, 251);
    private final Project project;
    private final VirtualFile file;
    private final JPanel panel;
    private JPanel thumbnailPanel;
    private List<ZipEntry> zipEntries = new ArrayList<ZipEntry>();
    private FileSystemView fileSystemView = FileSystemView.getFileSystemView();
    private JProgressBar statusProgressBar;
    private JButton buttonDelete;
    private JButton buttonAdd;
    private JButton buttonDelAll;
    private JButton buttonUpdate;
    private JButton buttonCancelSelect;

    public RcFileEditor(Project project, VirtualFile file) {
        this.project = project;
        this.file = file;
        this.panel = new JPanel(new BorderLayout());
        this.initUI();
        this.loadZipContents();
    }

    private void initUI() {
        this.panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.panel.setBackground(UIManager.getColor("Panel.background"));
        this.thumbnailPanel = new JPanel(new WrapLayout(0, 5, 5));
        this.thumbnailPanel.setBackground(this.panel.getBackground());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.thumbnailPanel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        JPanel buttonPanel = new JPanel(new FlowLayout(0, 5, 5));
        buttonPanel.setBackground(this.panel.getBackground());
        this.buttonAdd = this.addButton(buttonPanel, "\u6dfb\u52a0\u6587\u4ef6", this::addFile);
        this.buttonDelete = this.addButton(buttonPanel, "\u5220\u9664\u6587\u4ef6", this::deleteFile);
        this.buttonDelAll = this.addButton(buttonPanel, "\u5220\u9664\u6240\u6709", this::deleteAll);
        this.buttonUpdate = this.addButton(buttonPanel, "\u5237\u65b0", this::updateView);
        this.buttonCancelSelect = this.addButton(buttonPanel, "\u53d6\u6d88\u6240\u6709\u9009\u4e2d", this::cancelSelected);
        this.statusProgressBar = new JProgressBar();
        this.statusProgressBar.setVisible(false);
        this.statusProgressBar.setStringPainted(true);
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)buttonPanel, "North");
        southPanel.add((Component)this.statusProgressBar, "South");
        southPanel.setBackground(this.panel.getBackground());
        this.panel.add((Component)scrollPane, "Center");
        this.panel.add((Component)southPanel, "South");
    }

    private void setAllButtonEnable(boolean b) {
        this.buttonAdd.setEnabled(b);
        this.buttonDelete.setEnabled(b);
        this.buttonDelAll.setEnabled(b);
        this.buttonUpdate.setEnabled(b);
        this.buttonCancelSelect.setEnabled(b);
    }

    private JButton addButton(JPanel panel, String text, ActionListener listener) {
        JButton button = new JButton(text);
        button.setFont(button.getFont().deriveFont(0, 11.0f));
        button.setPreferredSize(new Dimension(75, 26));
        button.addActionListener(listener);
        panel.add(button);
        return button;
    }

    private void loadZipContents() {
        this.thumbnailPanel.removeAll();
        this.zipEntries.clear();
        try (InputStream input = this.file.getInputStream();
             ZipInputStream zipInput = new ZipInputStream(input);){
            ZipEntry entry;
            ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
            while ((entry = zipInput.getNextEntry()) != null) {
                if (entry.getName().startsWith("res/") && !entry.isDirectory()) {
                    entries.add(entry);
                }
                zipInput.closeEntry();
            }
            entries.sort(Comparator.comparing(e -> e.getName().toLowerCase()));
            for (ZipEntry zipEntry : entries) {
                String fileName = zipEntry.getName().substring(zipEntry.getName().lastIndexOf(47) + 1);
                this.zipEntries.add(zipEntry);
                this.addFileThumbnail(zipEntry, fileName);
            }
        }
        catch (IOException e2) {
            this.showError("Error loading file: " + e2.getMessage());
        }
        this.thumbnailPanel.revalidate();
        this.thumbnailPanel.repaint();
    }

    private void addFileThumbnail(ZipEntry zipEntry, String fileName) {
        JPanel filePanel = new JPanel(new BorderLayout());
        filePanel.setPreferredSize(new Dimension(70, 90));
        filePanel.setBackground(this.thumbnailPanel.getBackground());
        filePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel iconPanel = new JPanel(new BorderLayout());
        iconPanel.setBackground(filePanel.getBackground());
        iconPanel.setPreferredSize(new Dimension(50, 50));
        JLabel iconLabel = new JLabel();
        iconLabel.setHorizontalAlignment(0);
        iconLabel.setVerticalAlignment(0);
        if (this.isImageFile(fileName)) {
            this.loadImageThumbnail(zipEntry, iconLabel);
        } else {
            Icon systemIcon = this.fileSystemView.getSystemIcon(new File(fileName));
            if (systemIcon != null) {
                iconLabel.setIcon(this.scaleIcon(systemIcon, 45));
            } else {
                iconLabel.setIcon(UIManager.getIcon("FileView.fileIcon"));
            }
        }
        JLabel nameLabel = new JLabel(this.formatFileName(fileName), 0);
        nameLabel.setFont(nameLabel.getFont().deriveFont(0, 11.0f));
        nameLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        iconPanel.add((Component)iconLabel, "Center");
        filePanel.add((Component)iconPanel, "Center");
        filePanel.add((Component)nameLabel, "South");
        this.setupFilePanelInteractions(filePanel, fileName);
        this.thumbnailPanel.add(filePanel);
    }

    private void loadImageThumbnail(ZipEntry zipEntry, JLabel iconLabel) {
        try (InputStream imgInput = this.file.getInputStream();
             ZipInputStream imgZipInput = new ZipInputStream(imgInput);){
            ZipEntry imgEntry;
            while ((imgEntry = imgZipInput.getNextEntry()) != null) {
                if (!imgEntry.getName().equals(zipEntry.getName())) continue;
                ImageIcon originalIcon = new ImageIcon(imgZipInput.readAllBytes());
                Image scaledImage = originalIcon.getImage().getScaledInstance(40, 40, 4);
                iconLabel.setIcon(new ImageIcon(scaledImage));
                break;
            }
        }
        catch (IOException e) {
            iconLabel.setIcon(this.scaleIcon(UIManager.getIcon("FileView.fileIcon"), 40));
        }
    }

    private Icon scaleIcon(final Icon icon, int size) {
        if (icon == null) {
            return null;
        }
        Image image = new ImageIcon(){

            @Override
            public int getIconWidth() {
                return icon.getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                icon.paintIcon(c, g, x, y);
            }
        }.getImage();
        return new ImageIcon(image.getScaledInstance(size, size, 4));
    }

    private String formatFileName(String fileName) {
        if (fileName.length() > 20) {
            return "<html><center>" + fileName.substring(0, 15) + "..." + fileName.substring(fileName.lastIndexOf(46)) + "</center></html>";
        }
        return fileName;
    }

    private void setupFilePanelInteractions(final JPanel filePanel, String fileName) {
        filePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!RcFileEditor.this.isSelected(filePanel)) {
                    // empty if block
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!RcFileEditor.this.isSelected(filePanel)) {
                    filePanel.setBackground(RcFileEditor.this.thumbnailPanel.getBackground());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                RcFileEditor.this.toggleSelection(filePanel);
            }
        });
    }

    private boolean isSelected(JPanel filePanel) {
        return filePanel.getBackground().equals(SELECTION_COLOR);
    }

    private void toggleSelection(JPanel filePanel) {
        if (this.isSelected(filePanel)) {
            filePanel.setBackground(this.thumbnailPanel.getBackground());
            filePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        } else {
            filePanel.setBackground(SELECTION_COLOR);
            filePanel.setBorder(new LineBorder(new Color(42, 130, 218), 2));
        }
    }

    private boolean isImageFile(String fileName) {
        String lower = fileName.toLowerCase();
        return lower.endsWith(".jpg") || lower.endsWith(".jpeg") || lower.endsWith(".png") || lower.endsWith(".gif") || lower.endsWith(".bmp");
    }

    private void deleteFile(ActionEvent e) {
        this.setAllButtonEnable(false);
        final List<String> selectedFiles = this.getSelectedFiles();
        if (selectedFiles.isEmpty()) {
            this.showError("\u8bf7\u5148\u9009\u62e9\u8981\u5220\u9664\u7684\u6587\u4ef6");
            this.setAllButtonEnable(true);
            return;
        }
        if (!this.confirmDelete("\u5220\u9664 " + selectedFiles.size() + " \u9009\u62e9\u7684\u6587\u4ef6(s)?")) {
            this.setAllButtonEnable(true);
            return;
        }
        this.statusProgressBar.setVisible(true);
        this.statusProgressBar.setIndeterminate(true);
        this.statusProgressBar.setString("\u6b63\u5728\u5220\u9664\u8bf7\u7a0d\u7b49");
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try (InputStream is = RcFileEditor.this.file.getInputStream();
                     ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    try (ZipOutputStream zos = new ZipOutputStream(baos);
                         ZipInputStream zis = new ZipInputStream(is);){
                        ZipEntry entry;
                        while ((entry = zis.getNextEntry()) != null) {
                            String entryName = entry.getName();
                            if (entryName.startsWith("res/") && selectedFiles.contains(entryName.substring(entryName.lastIndexOf(47) + 1))) continue;
                            zos.putNextEntry(new ZipEntry(entry.getName()));
                            zis.transferTo(zos);
                            zos.closeEntry();
                        }
                    }
                    ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                        try (OutputStream os = RcFileEditor.this.file.getOutputStream((Object)new LargeFileWriteRequestor(){});){
                            RcFileEditor.this.file.refresh(false, false);
                            os.write(baos.toByteArray());
                        }
                        catch (IOException ex) {
                            throw new RuntimeException("Error writing file: " + ex.getMessage(), ex);
                        }
                    }));
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error processing files: " + ex.getMessage(), ex);
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    SwingUtilities.invokeLater(() -> {
                        RcFileEditor.this.loadZipContents();
                        RcFileEditor.this.statusProgressBar.setVisible(false);
                        RcFileEditor.this.setAllButtonEnable(true);
                    });
                }
                catch (Exception ex) {
                    SwingUtilities.invokeLater(() -> {
                        RcFileEditor.this.statusProgressBar.setVisible(false);
                        RcFileEditor.this.setAllButtonEnable(true);
                        RcFileEditor.this.showError("Error deleting files: " + ex.getCause().getMessage());
                    });
                }
            }
        }.execute();
    }

    private void addFile(ActionEvent e) {
        this.setAllButtonEnable(false);
        this.statusProgressBar.setVisible(false);
        this.statusProgressBar.setIndeterminate(true);
        this.statusProgressBar.setString("\u6b63\u5728\u6dfb\u52a0\u6587\u4ef6");
        new SwingWorker<Void, Integer>(){
            private List<File> filesToAdd = new ArrayList<File>();
            private Set<String> existingEntries = new HashSet<String>();

            @Override
            protected Void doInBackground() throws Exception {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setMultiSelectionEnabled(true);
                if (fileChooser.showOpenDialog(RcFileEditor.this.panel) != 0) {
                    return null;
                }
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        try (ZipInputStream zis = new ZipInputStream(RcFileEditor.this.file.getInputStream());){
                            ZipEntry entry;
                            while ((entry = zis.getNextEntry()) != null) {
                                this.existingEntries.add(entry.getName());
                            }
                        }
                        catch (IOException ex) {
                            throw new RuntimeException("\u65e0\u6cd5\u8bfb\u53d6ZIP\u6587\u4ef6: " + ex.getMessage(), ex);
                        }
                    });
                }
                catch (Exception ex) {
                    throw new IOException("\u68c0\u67e5\u73b0\u6709\u6587\u4ef6\u5931\u8d25", ex);
                }
                List<File> selectedFiles = Arrays.asList(fileChooser.getSelectedFiles());
                if (selectedFiles.isEmpty()) {
                    return null;
                }
                SwingUtilities.invokeAndWait(() -> {
                    for (File newFile : selectedFiles) {
                        int confirm;
                        String newFileName = "res/" + newFile.getName();
                        if (this.existingEntries.contains(newFileName) && (confirm = JOptionPane.showConfirmDialog(RcFileEditor.this.panel, "\u6587\u4ef6 " + newFile.getName() + " \u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\uff1f", "\u786e\u8ba4", 0, 3)) != 0) continue;
                        this.filesToAdd.add(newFile);
                    }
                });
                this.publish(this.filesToAdd.size());
                RcFileEditor.this.statusProgressBar.setVisible(true);
                RcFileEditor.this.statusProgressBar.setString("\u6b63\u5728\u6dfb\u52a0 " + this.filesToAdd.size() + " \u4e2a\u6587\u4ef6");
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                     ZipOutputStream zos = new ZipOutputStream(baos);
                     ZipInputStream zis = new ZipInputStream(RcFileEditor.this.file.getInputStream());){
                    ZipEntry entry;
                    for (File newFile : this.filesToAdd) {
                        String newFileName = "res/" + newFile.getName();
                        zos.putNextEntry(new ZipEntry(newFileName));
                        Files.copy(newFile.toPath(), zos);
                        zos.closeEntry();
                        this.publish(this.filesToAdd.indexOf(newFile) + 1);
                    }
                    while ((entry = zis.getNextEntry()) != null) {
                        String entryName = entry.getName();
                        if (!this.filesToAdd.stream().noneMatch(f -> entryName.equals("res/" + f.getName()))) continue;
                        zos.putNextEntry(new ZipEntry(entryName));
                        zis.transferTo(zos);
                        zos.closeEntry();
                    }
                    zos.finish();
                    ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                        try (OutputStream os = RcFileEditor.this.file.getOutputStream((Object)new LargeFileWriteRequestor(){});){
                            os.write(baos.toByteArray());
                        }
                        catch (IOException ex) {
                            throw new RuntimeException("\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25: " + ex.getMessage(), ex);
                        }
                    }));
                }
                return null;
            }

            @Override
            protected void process(List<Integer> chunks) {
                int progress = chunks.get(chunks.size() - 1);
                RcFileEditor.this.statusProgressBar.setString(String.format("\u6b63\u5728\u6dfb\u52a0\u6587\u4ef6 (%d/%d)", progress, this.filesToAdd.size()));
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    SwingUtilities.invokeLater(() -> {
                        RcFileEditor.this.loadZipContents();
                        RcFileEditor.this.statusProgressBar.setVisible(false);
                        RcFileEditor.this.setAllButtonEnable(true);
                        if (!this.filesToAdd.isEmpty()) {
                            // empty if block
                        }
                    });
                }
                catch (Exception ex) {
                    SwingUtilities.invokeLater(() -> {
                        RcFileEditor.this.statusProgressBar.setVisible(false);
                        RcFileEditor.this.setAllButtonEnable(true);
                        RcFileEditor.this.showError("\u6dfb\u52a0\u6587\u4ef6\u5931\u8d25: " + (ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage()));
                    });
                }
            }
        }.execute();
    }

    private boolean checkFileExists(ZipInputStream zis, String fileName) throws IOException {
        ZipEntry entry;
        while ((entry = zis.getNextEntry()) != null) {
            if (!entry.getName().equals(fileName)) continue;
            return true;
        }
        return false;
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void updateView(ActionEvent e) {
        this.loadZipContents();
    }

    private void cancelSelected(ActionEvent e) {
        for (Component comp : this.thumbnailPanel.getComponents()) {
            if (!(comp instanceof JPanel)) continue;
            JPanel filePanel = (JPanel)comp;
            filePanel.setBackground(this.thumbnailPanel.getBackground());
            filePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }
        this.thumbnailPanel.revalidate();
        this.thumbnailPanel.repaint();
    }

    private void deleteAll(ActionEvent e) {
        this.setAllButtonEnable(false);
        if (!this.confirmDelete("\u662f\u5426\u5220\u9664\u6240\u6709\u6587\u4ef6")) {
            this.setAllButtonEnable(true);
            return;
        }
        this.statusProgressBar.setVisible(true);
        this.statusProgressBar.setIndeterminate(true);
        this.statusProgressBar.setString("Deleting all files...");
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try (InputStream is = RcFileEditor.this.file.getInputStream();
                     ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    try (ZipOutputStream zos = new ZipOutputStream(baos);
                         ZipInputStream zis = new ZipInputStream(is);){
                        ZipEntry entry;
                        while ((entry = zis.getNextEntry()) != null) {
                            if (!entry.isDirectory() && entry.getName().startsWith("res/")) continue;
                            zos.putNextEntry(new ZipEntry(entry.getName()));
                            if (!entry.isDirectory()) {
                                zis.transferTo(zos);
                            }
                            zos.closeEntry();
                        }
                    }
                    ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                        try (OutputStream os = RcFileEditor.this.file.getOutputStream((Object)new LargeFileWriteRequestor(){});){
                            RcFileEditor.this.file.refresh(false, false);
                            os.write(baos.toByteArray());
                        }
                        catch (IOException ex) {
                            throw new RuntimeException("Error writing file: " + ex.getMessage(), ex);
                        }
                    }));
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error processing files: " + ex.getMessage(), ex);
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    SwingUtilities.invokeLater(() -> {
                        RcFileEditor.this.loadZipContents();
                        RcFileEditor.this.statusProgressBar.setVisible(false);
                        RcFileEditor.this.setAllButtonEnable(true);
                        RcFileEditor.this.statusProgressBar.setString("All files deleted");
                    });
                }
                catch (Exception ex) {
                    SwingUtilities.invokeLater(() -> {
                        RcFileEditor.this.statusProgressBar.setVisible(false);
                        RcFileEditor.this.setAllButtonEnable(true);
                        RcFileEditor.this.showError("Error deleting files: " + ex.getCause().getMessage());
                    });
                }
            }
        }.execute();
    }

    private List<String> getSelectedFiles() {
        ArrayList<String> selectedFiles = new ArrayList<String>();
        for (Component comp : this.thumbnailPanel.getComponents()) {
            if (!(comp instanceof JPanel) || !((JPanel)comp).getBackground().equals(SELECTION_COLOR)) continue;
            for (Component child : ((JPanel)comp).getComponents()) {
                String text;
                if (!(child instanceof JLabel) || (text = ((JLabel)child).getText()) == null || text.isEmpty()) continue;
                selectedFiles.add(text.replaceAll("<[^>]*>", ""));
            }
        }
        return selectedFiles;
    }

    private boolean confirmDelete(String message) {
        return JOptionPane.showConfirmDialog(this.panel, message, "Confirm Delete", 0) == 0;
    }

    private void showError(String message) {
        JOptionPane.showMessageDialog(this.panel, message, "Error", 0);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.file;
        if (virtualFile == null) {
            RcFileEditor.$$$reportNull$$$0(0);
        }
        return virtualFile;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.panel;
        if (jPanel == null) {
            RcFileEditor.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.thumbnailPanel;
    }

    @NotNull
    public String getName() {
        return "RC Archive Viewer";
    }

    public void dispose() {
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            RcFileEditor.$$$reportNull$$$0(2);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            RcFileEditor.$$$reportNull$$$0(3);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            RcFileEditor.$$$reportNull$$$0(4);
        }
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            RcFileEditor.$$$reportNull$$$0(5);
        }
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            RcFileEditor.$$$reportNull$$$0(6);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/nx/nxprojit/module/RcFileEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/nx/nxprojit/module/RcFileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

