/*
 * Decompiled with CFR 0.152.
 */
package com.nx.nxprojit.module;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.nx.nxprojit.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MixModuleWizardStep
extends ModuleWizardStep {
    private JBTextField packageNameField;
    private JBLabel validationLabel;
    private JBRadioButton jbLua;
    private JBRadioButton jbMixGo;
    private static final Pattern PACKAGE_NAME_PATTERN = Pattern.compile("^[a-z][a-z0-9_]*(\\.[a-z][a-z0-9_]*)+$");

    public JComponent getComponent() {
        return this.createPanel("");
    }

    public JPanel createPanel(String str) {
        JBPanel mainPanel = new JBPanel((LayoutManager)new BorderLayout(10, 10));
        JBLabel titleLabel = new JBLabel(str);
        titleLabel.setFont(titleLabel.getFont().deriveFont(1, 14.0f));
        mainPanel.add((Component)titleLabel, (Object)"North");
        JBPanel contentPanel = new JBPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        contentPanel.add((Component)new JBLabel("\u61d2\u4eba\u9879\u76ee\u7c7b\u578b:"), (Object)gbc);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.jbLua = new JBRadioButton("\u7eafLua\u9879\u76ee", true);
        this.jbMixGo = new JBRadioButton("Go\u548cLua\u6df7\u5408\u9879\u76ee", false);
        buttonGroup.add((AbstractButton)this.jbLua);
        buttonGroup.add((AbstractButton)this.jbMixGo);
        ++gbc.gridy;
        contentPanel.add((Component)this.jbLua, (Object)gbc);
        ++gbc.gridy;
        contentPanel.add((Component)this.jbMixGo, (Object)gbc);
        ++gbc.gridy;
        contentPanel.add((Component)new JBLabel("\u9879\u76ee\u5305\u540d:"), (Object)gbc);
        this.packageNameField = new JBTextField();
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        contentPanel.add((Component)this.packageNameField, (Object)gbc);
        this.validationLabel = new JBLabel(" ");
        this.validationLabel.setForeground(Color.RED);
        ++gbc.gridy;
        contentPanel.add((Component)this.validationLabel, (Object)gbc);
        ItemListener typeListener = e -> {
            if (e.getStateChange() == 1) {
                if (e.getSource() == this.jbLua) {
                    Utils.PROJECT_TYPE = 0;
                } else if (e.getSource() == this.jbMixGo) {
                    Utils.PROJECT_TYPE = 1;
                }
                this.validatePackageName();
            }
        };
        this.jbLua.addItemListener(typeListener);
        this.jbMixGo.addItemListener(typeListener);
        this.packageNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MixModuleWizardStep.this.validatePackageName();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MixModuleWizardStep.this.validatePackageName();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MixModuleWizardStep.this.validatePackageName();
            }
        });
        this.packageNameField.setEnabled(true);
        mainPanel.add((Component)contentPanel, (Object)"Center");
        return mainPanel;
    }

    private void validatePackageName() {
        String packageName = this.packageNameField.getText().trim();
        if (packageName.isEmpty()) {
            this.validationLabel.setText("\u5305\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (!PACKAGE_NAME_PATTERN.matcher(packageName).matches()) {
            this.validationLabel.setText("\u5305\u540d\u683c\u5f0f\u65e0\u6548: \u5fc5\u987b\u4e3a\u5c0f\u5199\u5b57\u6bcd\u5f00\u5934\uff0c\u4f7f\u7528\u70b9\u5206\u9694\u7684\u6807\u8bc6\u7b26");
            return;
        }
        this.validationLabel.setText(" ");
    }

    public boolean validate() {
        String packageName = this.packageNameField.getText().trim();
        if (packageName.isEmpty()) {
            Messages.showErrorDialog((String)"\u5305\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"\u65e0\u6548\u7684\u5305\u540d");
            return false;
        }
        if (!PACKAGE_NAME_PATTERN.matcher(packageName).matches()) {
            Messages.showErrorDialog((String)"\u5305\u540d\u683c\u5f0f\u65e0\u6548!\n\u5fc5\u987b\u7b26\u5408\u4ee5\u4e0b\u89c4\u5219:\n- \u5c0f\u5199\u5b57\u6bcd\u5f00\u5934\n- \u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\n- \u4f7f\u7528\u70b9(.)\u5206\u9694\u5404\u90e8\u5206\n\u4f8b\u5982: com.example.myapp", (String)"\u65e0\u6548\u7684\u5305\u540d");
            return false;
        }
        Utils.PROJECT_TYPE = this.getSelectedProjectType();
        return true;
    }

    public void updateDataModel() {
        String packageName = this.packageNameField.getText().trim();
        if (!packageName.isEmpty()) {
            Utils.PACKAGE_NAME = packageName;
        }
        Utils.PROJECT_TYPE = this.getSelectedProjectType();
    }

    private int getSelectedProjectType() {
        if (this.jbLua.isSelected()) {
            return 0;
        }
        if (this.jbMixGo.isSelected()) {
            return 1;
        }
        return 0;
    }
}

