/*
 * Decompiled with CFR 0.152.
 */
package com.nx.nxprojit.action;

import com.google.gson.JsonObject;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.VerticalLayout;
import com.nx.nxprojit.utils.ScriptMgr;
import com.nx.nxprojit.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class UiComonet
extends SimpleToolWindowPanel {
    private final Project project;
    private final Map<String, JPanel> contentPanels = new HashMap<String, JPanel>();

    public UiComonet(Project project) {
        super(true, true);
        this.project = project;
        this.initUI(project);
    }

    private void initUI(final Project project) {
        JBPanel containerPanel = new JBPanel((LayoutManager)new BorderLayout());
        JBPanel mainPanel = new JBPanel((LayoutManager)new VerticalLayout(5));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addCollapsibleSection((JPanel)mainPanel, "\u5e03\u5c40\u7c7b\u578b", new String[]{"\u7a97\u53e3", "\u6c34\u5e73\u5e03\u5c40", "\u5782\u76f4\u5e03\u5c40", "\u6807\u7b7e\u9875"}, true);
        this.addCollapsibleSection((JPanel)mainPanel, "\u63a7\u4ef6\u7c7b\u578b", new String[]{"\u6309\u94ae", "\u6587\u672c\u6846", "\u8f93\u5165\u6846", "\u4e0b\u62c9\u6846", "\u591a\u9009\u6846", "\u5355\u9009\u6846", "\u6d4f\u89c8\u5668"}, true);
        JBScrollPane scrollPane = new JBScrollPane((Component)mainPanel);
        scrollPane.setBorder(null);
        containerPanel.add((Component)scrollPane, (Object)"Center");
        JBPanel bottomPanel = new JBPanel((LayoutManager)new FlowLayout(1, 10, 5));
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton previewButton = this.createStyledButton("\u9884\u89c8\u5e03\u5c40");
        previewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (project == null) {
                    return;
                }
                VirtualFile virtualFile = FileEditorManager.getInstance((Project)project).getSelectedFiles()[0];
                if (virtualFile != null) {
                    String filePath = virtualFile.getPath();
                    if (filePath.endsWith(".ui")) {
                        if (ScriptMgr.getInstance().isConnected(project)) {
                            ScriptMgr.getInstance().showUI(project, filePath);
                        } else {
                            Utils.showTooltipNotification("\u670d\u52a1\u6ca1\u6709\u542f\u52a8\uff0c\u53ef\u4ee5\u5c1d\u8bd5\u53f3\u952e\u91cd\u542f\u670d\u52a1");
                        }
                    } else {
                        Utils.showTooltipNotification("\u5f53\u524d\u9875\u9762\u4e0d\u662f\u4e00\u4e2aui\u6587\u4ef6");
                    }
                    System.out.println("\u5f53\u524d\u6587\u4ef6\u8def\u5f84: " + filePath);
                }
            }
        });
        JButton colorPickerButton = this.createStyledButton("\u62fe\u53d6\u989c\u8272");
        colorPickerButton.addActionListener(e -> this.showColorPicker());
        bottomPanel.add((Component)previewButton);
        bottomPanel.add((Component)colorPickerButton);
        containerPanel.add((Component)bottomPanel, (Object)"South");
        this.setContent((JComponent)containerPanel);
    }

    private JButton createStyledButton(String text) {
        JButton button = new JButton(text);
        button.setBorder(new CompoundBorder(new LineBorder(UIManager.getColor("Button.borderColor"), 1), new EmptyBorder(5, 10, 5, 10)));
        button.setBackground(UIManager.getColor("Button.background"));
        button.setForeground(UIManager.getColor("Button.foreground"));
        button.setFocusPainted(false);
        return button;
    }

    private void addCollapsibleSection(JPanel parent, String title, String[] items, boolean initiallyExpanded) {
        JBPanel headerPanel = new JBPanel((LayoutManager)new BorderLayout());
        headerPanel.setOpaque(false);
        JButton toggleButton = new JButton(title);
        toggleButton.setIcon(UIManager.getIcon(initiallyExpanded ? "Tree.expandedIcon" : "Tree.collapsedIcon"));
        toggleButton.setHorizontalAlignment(2);
        toggleButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        toggleButton.setContentAreaFilled(false);
        toggleButton.setFocusPainted(false);
        JBPanel contentPanel = new JBPanel((LayoutManager)new GridLayout(0, 1, 0, 5));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 10, 5));
        contentPanel.setVisible(initiallyExpanded);
        for (String item : items) {
            JButton itemButton = this.createStyledButton(item);
            itemButton.addActionListener(this.createItemActionListener(item));
            contentPanel.add((Component)itemButton);
        }
        toggleButton.addActionListener(e -> {
            boolean visible = !contentPanel.isVisible();
            contentPanel.setVisible(visible);
            toggleButton.setIcon(UIManager.getIcon(visible ? "Tree.expandedIcon" : "Tree.collapsedIcon"));
            parent.revalidate();
        });
        headerPanel.add((Component)toggleButton, (Object)"Center");
        parent.add((Component)headerPanel);
        parent.add((Component)contentPanel);
        this.contentPanels.put(title, (JPanel)contentPanel);
    }

    private void showColorPicker() {
        Window parentWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Color color = JColorChooser.showDialog(parentWindow, "\u9009\u62e9\u989c\u8272", Color.WHITE);
        if (color != null) {
            String hexColor = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()).toUpperCase();
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(hexColor));
            Notification notification = new Notification("ColorPicker", "\u989c\u8272\u5df2\u590d\u5236", "\u989c\u8272\u503c: " + hexColor + " \u5df2\u590d\u5236\u5230\u526a\u8d34\u677f", NotificationType.INFORMATION);
            Notifications.Bus.notify((Notification)notification, (Project)this.project);
        }
    }

    private ActionListener createItemActionListener(String itemName) {
        return e -> {
            String data;
            JsonObject obj;
            Map<String, JsonObject> m = Utils.loadUiComponents();
            if (m != null && (obj = m.get(itemName)) != null && StringUtil.isNotEmpty((String)(data = obj.get("data").getAsString()))) {
                UiComonet.copyToClipboard(data);
                Utils.showUiTooltipNotification(itemName);
            }
        };
    }

    private static void copyToClipboard(String text) {
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text));
    }
}

