/*
 * Decompiled with CFR 0.152.
 */
package com.nx.nxprojit.action;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.nx.nxprojit.utils.Utils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogConsole {
    ConsoleViewImpl consoleView;
    Project project;

    public LogConsole(Project project) {
        this.project = project;
        this.consoleView = this.createConsoleView(project);
        this.consoleView.setAutoscrolls(true);
        Utils.setConsole(project, this);
    }

    private ConsoleViewImpl createConsoleView(Project project) {
        TextConsoleBuilder createBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        createBuilder.setViewer(true);
        return (ConsoleViewImpl)createBuilder.getConsole();
    }

    private static String currentTime() {
        return new SimpleDateFormat("HH:mm:ss.SSS").format(new Date());
    }

    private String appendDate(ConsoleViewImpl consoleViewImpl, String path, int line, String str) {
        String str2 = "[" + LogConsole.currentTime() + "]";
        if (path != null && !path.isEmpty()) {
            str2 = str2 + "[" + path + "]";
        }
        if (line >= 0) {
            str2 = str2 + " #" + line + " ";
        }
        if (!(str2 = str2 + str).endsWith("\n")) {
            str2 = str2 + "\n";
        }
        return str2;
    }

    public void clear() {
        ConsoleViewImpl consoleView = this.getConsoleView();
        if (consoleView != null) {
            consoleView.clear();
        }
    }

    public void printInfo(Project project, int level, String path, int line, String str) {
        ConsoleViewContentType outputType;
        ConsoleViewImpl consoleView = this.getConsoleView();
        if (consoleView == null) {
            return;
        }
        Object message = str.endsWith("\n") ? str : str + "\n";
        ConsoleViewContentType consoleViewContentType = outputType = level == 0 ? ConsoleViewContentType.LOG_INFO_OUTPUT : ConsoleViewContentType.LOG_ERROR_OUTPUT;
        if (path != null && !path.isEmpty()) {
            VirtualFile vf;
            File absfile = new File(path);
            if (!absfile.exists()) {
                absfile = new File(project.getBasePath(), path);
            }
            if ((vf = LocalFileSystem.getInstance().findFileByPath(absfile.getAbsolutePath().replace("\\", "/"))) != null) {
                this.printWithHyperlink(project, consoleView, vf, line, (String)message, outputType);
                return;
            }
        }
        consoleView.print(this.appendDate(consoleView, path, line, (String)message), outputType);
    }

    private void printWithHyperlink(Project project, ConsoleViewImpl consoleView, VirtualFile vf, int line, String message, ConsoleViewContentType outputType) {
        String datePrefix = "[" + LogConsole.currentTime() + " " + vf.getName() + "]";
        consoleView.print(datePrefix, outputType);
        consoleView.printHyperlink(" #" + line + " ", (HyperlinkInfo)new OpenFileHyperlinkInfo(project, vf, line - 1, 0));
        consoleView.print(message, outputType);
    }

    public ConsoleViewImpl getConsoleView() {
        return this.consoleView;
    }
}

