/*
 * Decompiled with CFR 0.152.
 */
package com.nx.nxprojit.action;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.treeStructure.Tree;
import com.nx.nxprojit.utils.XmlToLuaConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class HelpComonet
extends SimpleToolWindowPanel {
    private final Tree tree;
    private final DefaultTreeModel treeModel;
    private final DefaultMutableTreeNode rootNode;
    private final JBTextField searchField;
    private final Map<String, List<XmlToLuaConverter.TipSymbol>> originalData = XmlToLuaConverter.getSymbolList();

    public HelpComonet(Project project) {
        super(true, true);
        this.rootNode = new DefaultMutableTreeNode("Root");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new Tree((TreeModel)this.treeModel);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.refreshTreeModel(this.originalData);
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TreePath path;
                if (evt.getClickCount() == 2 && (path = HelpComonet.this.tree.getPathForLocation(evt.getX(), evt.getY())) != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    boolean isSymbolNode = node.getUserObject() instanceof XmlToLuaConverter.TipSymbol;
                    boolean isCategoryNode = node.getUserObject() instanceof String;
                    if (isSymbolNode && !isCategoryNode) {
                        HelpComonet.this.showDemoDialog((XmlToLuaConverter.TipSymbol)node.getUserObject());
                    }
                }
            }
        });
        this.tree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode node;
                Object userObject;
                if (tree == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((userObject = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof String) {
                    this.setIcon(UIManager.getIcon("Tree.openIcon"));
                    this.append(userObject.toString());
                } else if (userObject instanceof XmlToLuaConverter.TipSymbol) {
                    XmlToLuaConverter.TipSymbol symbol = (XmlToLuaConverter.TipSymbol)userObject;
                    this.setIcon(UIManager.getIcon("Tree.leafIcon"));
                    this.append(symbol.label);
                    StringBuilder tooltip = new StringBuilder();
                    if (symbol.tip != null && !symbol.tip.isEmpty()) {
                        String tipText = symbol.tip.replace("\n", "<br>");
                        tooltip.append(tipText).append("<br>");
                    }
                    this.setToolTipText(tooltip.toString());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/nx/nxprojit/action/HelpComonet$2", "customizeCellRenderer"));
            }
        });
        new TreeSpeedSearch(this.tree, path -> {
            Object last = path.getLastPathComponent();
            if (last instanceof DefaultMutableTreeNode) {
                Object userObject = ((DefaultMutableTreeNode)last).getUserObject();
                if (userObject instanceof XmlToLuaConverter.TipSymbol) {
                    return ((XmlToLuaConverter.TipSymbol)userObject).name;
                }
                return userObject.toString();
            }
            return "";
        });
        this.searchField = new JBTextField();
        this.searchField.setPreferredSize(new Dimension(200, 30));
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                HelpComonet.this.filterTree();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                HelpComonet.this.filterTree();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                HelpComonet.this.filterTree();
            }
        });
        JButton searchButton = new JButton("\u67e5\u627e");
        searchButton.addActionListener(e -> this.filterTree());
        JPanel searchPanel = new JPanel(new BorderLayout());
        searchPanel.add((Component)this.searchField, "Center");
        searchPanel.add((Component)searchButton, "East");
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)searchPanel, "North");
        contentPanel.add((Component)new JBScrollPane((Component)this.tree), "Center");
        this.setContent(contentPanel);
    }

    private void filterTree() {
        String searchText = this.searchField.getText().toLowerCase();
        if (searchText.isEmpty()) {
            this.refreshTreeModel(this.originalData);
        } else {
            LinkedHashMap<String, List<XmlToLuaConverter.TipSymbol>> filteredData = new LinkedHashMap<String, List<XmlToLuaConverter.TipSymbol>>();
            for (Map.Entry<String, List<XmlToLuaConverter.TipSymbol>> entry : this.originalData.entrySet()) {
                String category = entry.getKey();
                ArrayList<XmlToLuaConverter.TipSymbol> filteredSymbols = new ArrayList<XmlToLuaConverter.TipSymbol>();
                for (XmlToLuaConverter.TipSymbol symbol : entry.getValue()) {
                    if (!symbol.name.toLowerCase().contains(searchText) && (symbol.label == null || !symbol.label.toLowerCase().contains(searchText)) && (symbol.tip == null || !symbol.tip.toLowerCase().contains(searchText))) continue;
                    filteredSymbols.add(symbol);
                }
                if (filteredSymbols.isEmpty()) continue;
                filteredData.put(category, filteredSymbols);
            }
            this.refreshTreeModel(filteredData);
            this.expandAllNodes((JTree)this.tree, 0, this.tree.getRowCount());
        }
    }

    private void refreshTreeModel(Map<String, List<XmlToLuaConverter.TipSymbol>> data) {
        this.rootNode.removeAllChildren();
        ArrayList<String> sortedCategories = new ArrayList<String>(data.keySet());
        Collections.sort(sortedCategories);
        for (String category : sortedCategories) {
            DefaultMutableTreeNode categoryNode = new DefaultMutableTreeNode(category);
            ArrayList<XmlToLuaConverter.TipSymbol> symbols = new ArrayList<XmlToLuaConverter.TipSymbol>((Collection)data.get(category));
            symbols.sort(Comparator.comparing(s -> s.name));
            for (XmlToLuaConverter.TipSymbol symbol : symbols) {
                categoryNode.add(new DefaultMutableTreeNode(symbol));
            }
            this.rootNode.add(categoryNode);
        }
        this.treeModel.reload();
    }

    private void expandAllNodes(JTree tree, int startingIndex, int rowCount) {
        for (int i = startingIndex; i < rowCount; ++i) {
            tree.expandRow(i);
        }
        if (tree.getRowCount() != rowCount) {
            this.expandAllNodes(tree, rowCount, tree.getRowCount());
        }
    }

    private void showDemoDialog(XmlToLuaConverter.TipSymbol symbol) {
        JDialog dialog = new JDialog();
        dialog.setTitle(symbol.name + " - \u4f8b\u5b50");
        dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setSize(600, 400);
        dialog.setLocationRelativeTo(null);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JTextArea textArea = new JTextArea(symbol.demo != null ? symbol.demo : "No example available");
        textArea.setEditable(false);
        textArea.setFont(new Font("Monospaced", 0, 12));
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(textArea);
        panel.add((Component)scrollPane, "Center");
        JButton copyButton = new JButton("\u590d\u5236\u5230\u526a\u8d34\u677f");
        copyButton.addActionListener(e -> {
            StringSelection stringSelection = new StringSelection(textArea.getText());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
            dialog.dispose();
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(copyButton);
        panel.add((Component)buttonPanel, "South");
        dialog.add(panel);
        dialog.setVisible(true);
    }
}

