/*
 * Decompiled with CFR 0.152.
 */
package com.nx.nxprojit.action;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.nx.nxprojit.module.UiFileType;
import com.nx.nxprojit.utils.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResFileAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            CreateResFileAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        String actionId = e.getActionManager().getId((AnAction)this);
        VirtualFile targetDir = this.getTargetDirectory(e, project);
        if (targetDir == null) {
            Messages.showErrorDialog((Project)project, (String)"No valid directory selected", (String)"Error");
            return;
        }
        String defaultFileName = "newfile";
        String dialogTitle = "\u521b\u5efa\u6587\u4ef6";
        if ("LrPlugin.CreateResFile".equals(actionId)) {
            defaultFileName = "resource.rc";
            dialogTitle = "\u521b\u5efarc\u8d44\u6e90\u6587\u4ef6";
        } else if ("LrPlugin.CreateUIFile".equals(actionId)) {
            defaultFileName = "newlayout.ui";
            dialogTitle = "\u521b\u5efaui\u754c\u9762\u6587\u4ef6";
        }
        String fileName = Messages.showInputDialog((Project)project, (String)"\u8f93\u5165\u540d\u79f0:", (String)dialogTitle, (Icon)Messages.getQuestionIcon(), (String)defaultFileName, (InputValidator)new FileNameValidator(targetDir));
        if (StringUtil.isEmpty((String)fileName)) {
            return;
        }
        if ("LrPlugin.CreateResFile".equals(actionId)) {
            this.copyResourceToVirtualFile(project, "/template/template.rc", targetDir, fileName);
        } else if ("LrPlugin.CreateUIFile".equals(actionId)) {
            this.copyResourceToVirtualFile(project, "/template/template.ui", targetDir, fileName);
        }
    }

    @Nullable
    private VirtualFile getTargetDirectory(@NotNull AnActionEvent e, @NotNull Project project) {
        VirtualFile selectedFile;
        if (e == null) {
            CreateResFileAction.$$$reportNull$$$0(1);
        }
        if (project == null) {
            CreateResFileAction.$$$reportNull$$$0(2);
        }
        if ((selectedFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null && selectedFile.isDirectory()) {
            return selectedFile;
        }
        if (selectedFile != null) {
            return selectedFile.getParent();
        }
        return project.getBaseDir();
    }

    public boolean copyResourceToVirtualFile(Project project, @NotNull String resourcePath, @NotNull VirtualFile dir, String fileName) {
        boolean bl;
        block11: {
            if (resourcePath == null) {
                CreateResFileAction.$$$reportNull$$$0(3);
            }
            if (dir == null) {
                CreateResFileAction.$$$reportNull$$$0(4);
            }
            Object normalizedPath = resourcePath.startsWith("/") ? resourcePath : "/" + resourcePath;
            InputStream inputStream = FileUtils.class.getResourceAsStream((String)normalizedPath);
            try {
                if (inputStream == null) {
                    throw new IOException("Resource not found: " + (String)normalizedPath);
                }
                ApplicationManager.getApplication().invokeAndWait(() -> WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                    try {
                        if (dir.findChild(fileName) != null) {
                            Messages.showErrorDialog((Project)project, (String)("File already exists: " + fileName), (String)"Error");
                            return;
                        }
                        VirtualFile file = dir.createChildData((Object)this, fileName);
                        try (OutputStream outputStream = file.getOutputStream((Object)this);){
                            StreamUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to copy resource to file", e);
                    }
                }));
                bl = true;
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    private void createFile(Project project, VirtualFile dir, String fileName, String content) {
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            try {
                if (dir.findChild(fileName) != null) {
                    Messages.showErrorDialog((Project)project, (String)("File already exists: " + fileName), (String)"Error");
                    return;
                }
                VirtualFile file = dir.createChildData((Object)this, fileName);
                file.setBinaryContent(content.getBytes(StandardCharsets.UTF_8));
                FileEditorManager.getInstance((Project)project).openFile(file, true);
            }
            catch (IOException ex) {
                Messages.showErrorDialog((Project)project, (String)("Failed to create file: " + ex.getMessage()), (String)"Error");
            }
            catch (IllegalArgumentException ex) {
                Messages.showErrorDialog((Project)project, (String)("Invalid file name: " + ex.getMessage()), (String)"Error");
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CreateResFileAction.$$$reportNull$$$0(5);
        }
        Project project = e.getProject();
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean enabled = project != null && (file == null || file.isDirectory() || file.isValid() && file.getParent() != null);
        e.getPresentation().setEnabledAndVisible(enabled);
        String actionId = e.getActionManager().getId((AnAction)this);
        if ("LrPlugin.CreateResFile".equals(actionId)) {
            e.getPresentation().setText("rc\u8d44\u6e90\u4ef6");
            e.getPresentation().setDescription("\u521b\u5efa\u8d44\u6e90\u6587\u4ef6");
            e.getPresentation().setIcon(AllIcons.FileTypes.Archive);
        } else if ("LrPlugin.CreateUIFile".equals(actionId)) {
            e.getPresentation().setText("\u754c\u9762\u6587\u4ef6");
            e.getPresentation().setDescription("\u521b\u5efa\u754c\u9762\u6587\u4ef6");
            e.getPresentation().setIcon(IconLoader.getIcon((String)"/images/ui.svg", UiFileType.class));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CreateResFileAction.$$$reportNull$$$0(6);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/nx/nxprojit/action/CreateResFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/nx/nxprojit/action/CreateResFileAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTargetDirectory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyResourceToVirtualFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private static class FileNameValidator
    implements InputValidator {
        private final VirtualFile targetDir;

        public FileNameValidator(VirtualFile targetDir) {
            this.targetDir = targetDir;
        }

        public boolean checkInput(String input) {
            return input != null && !input.trim().isEmpty() && !input.contains("/") && !input.contains("\\") && !input.contains(":") && !input.contains("*") && !input.contains("?") && !input.contains("\"") && !input.contains("<") && !input.contains(">") && !input.contains("|");
        }

        public boolean canClose(String input) {
            return this.checkInput(input) && this.targetDir.findChild(input) == null;
        }
    }
}

